/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import option.gad.core.util.Closure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileIOUtil {
    private static final Log i = LogFactory.getLog(FileIOUtil.class);

    protected FileIOUtil() {
    }

    public static String readText(File file, String string) {
        String string2 = null;
        try {
            string2 = FileIOUtil.readText(new FileInputStream(file), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            i.error((Object)"", (Throwable)fileNotFoundException);
        }
        return string2;
    }

    public static String readText(InputStream object, String object2) {
        String string;
        block6: {
            string = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    int n;
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, (String)object2));
                    object = new StringBuffer();
                    while ((n = ((Reader)bufferedReader).read((char[])(object2 = (Object)new char[81920]), 0, 81920)) != -1) {
                        ((StringBuffer)object).append((char[])object2, 0, n);
                    }
                    string = ((StringBuffer)object).toString();
                }
                catch (Exception exception) {
                    i.error((Object)"", (Throwable)exception);
                    FileIOUtil.close(bufferedReader);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileIOUtil.close(bufferedReader);
                throw throwable;
            }
            FileIOUtil.close(bufferedReader);
        }
        return string;
    }

    public static void readText(File object, String string, Closure<String, Boolean> closure) {
        try {
            object = new FileInputStream((File)object);
            FileIOUtil.readText((InputStream)object, string, closure);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            i.info((Object)"", (Throwable)fileNotFoundException);
            return;
        }
    }

    public static void readText(String object, String string, Closure<String, Boolean> closure) {
        object = FileIOUtil.class.getResourceAsStream((String)object);
        FileIOUtil.readText((InputStream)object, string, closure);
    }

    public static void readText(InputStream closeable, String string, Closure<String, Boolean> closure) {
        try {
            closeable = new InputStreamReader((InputStream)closeable, string);
            FileIOUtil.readText((Reader)closeable, closure);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            i.info((Object)"", (Throwable)unsupportedEncodingException);
            return;
        }
    }

    public static void readText(Reader reader, Closure<String, Boolean> closure) {
        BufferedReader bufferedReader = null;
        try {
            try {
                boolean bl;
                String string;
                bufferedReader = new BufferedReader(reader);
                while ((string = bufferedReader.readLine()) != null && (bl = closure.execute(string).booleanValue())) {
                }
            }
            catch (Exception exception) {
                i.info((Object)"", (Throwable)exception);
                FileIOUtil.close(bufferedReader);
                return;
            }
        }
        catch (Throwable throwable) {
            FileIOUtil.close(bufferedReader);
            throw throwable;
        }
        FileIOUtil.close(bufferedReader);
    }

    public static boolean writeText(File file, String string, String string2) {
        boolean bl;
        block5: {
            bl = false;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2));
                    bufferedWriter.write(string);
                    ((Writer)bufferedWriter).flush();
                    bl = true;
                }
                catch (Exception exception) {
                    i.error((Object)"", (Throwable)exception);
                    FileIOUtil.close(bufferedWriter);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileIOUtil.close(bufferedWriter);
                throw throwable;
            }
            FileIOUtil.close(bufferedWriter);
        }
        return bl;
    }

    public static InputStream readOpen(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static boolean read(File file, OutputStream outputStream) {
        boolean bl;
        block5: {
            bl = false;
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    bl = FileIOUtil.write(outputStream, (InputStream)bufferedInputStream);
                }
                catch (Exception exception) {
                    i.error((Object)"", (Throwable)exception);
                    FileIOUtil.close(bufferedInputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileIOUtil.close(bufferedInputStream);
                throw throwable;
            }
            FileIOUtil.close(bufferedInputStream);
        }
        return bl;
    }

    public static boolean write(File file, InputStream inputStream) {
        boolean bl;
        block5: {
            bl = false;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    bl = FileIOUtil.write(bufferedOutputStream, inputStream);
                }
                catch (Exception exception) {
                    i.error((Object)"", (Throwable)exception);
                    FileIOUtil.close(bufferedOutputStream);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileIOUtil.close(bufferedOutputStream);
                throw throwable;
            }
            FileIOUtil.close(bufferedOutputStream);
        }
        return bl;
    }

    public static boolean write(OutputStream outputStream, InputStream inputStream) {
        boolean bl = false;
        try {
            int n = 0;
            byte[] byArray = new byte[81920];
            while ((n = inputStream.read(byArray, 0, 81920)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            bl = true;
        }
        catch (Exception exception) {
            i.error((Object)"", (Throwable)exception);
        }
        return bl;
    }

    public static byte[] fileToBytes(File file) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileIOUtil.read(file, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void bytesToFile(File file, byte[] object) {
        object = new ByteArrayInputStream((byte[])object);
        FileIOUtil.write(file, (InputStream)object);
    }

    public static boolean close(InputStream inputStream) {
        boolean bl = true;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                bl = false;
                i.error((Object)"", (Throwable)iOException);
            }
        }
        return bl;
    }

    public static boolean close(OutputStream outputStream) {
        boolean bl = true;
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                bl = false;
                i.error((Object)"", (Throwable)iOException);
            }
        }
        return bl;
    }

    public static boolean close(Reader reader) {
        boolean bl = true;
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                bl = false;
                i.error((Object)"", (Throwable)iOException);
            }
        }
        return bl;
    }

    public static boolean close(Writer writer) {
        boolean bl = true;
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                bl = false;
                i.error((Object)"", (Throwable)iOException);
            }
        }
        return bl;
    }
}

