/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.dao;

import com.kt.io.AbstFile;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import com.kt.util.xml.XMLManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import option.gad.core.io.FileIOUtil;
import option.gad.core.util.xml.GdXMLWriter;

public class ObjectFolderDao {
    protected AbstFile mInputAbstFile = null;
    protected OutputStream mOutputStream = null;
    protected AbstFile mOutputAbstFile = null;

    public ObjectFolder load() {
        XMLManager xMLManager = new XMLManager();
        xMLManager.load(this.mInputAbstFile);
        return xMLManager.getTree();
    }

    public void save(ObjectFolder objectFolder) {
        PrintStream printStream = new PrintStream(this.mOutputAbstFile.getOutpuStreamToBuffer());
        printStream.println("<?xml version='1.0' encoding='Shift_JIS'?>");
        GdXMLWriter.write((ObjectNode)objectFolder, "", printStream);
        this.mOutputAbstFile.closeNewFileToBuffer();
        this.mOutputAbstFile.BufferToOutputStream(this.mOutputStream);
        FileIOUtil.close(printStream);
        FileIOUtil.close(this.mOutputStream);
    }

    public void setInput(File file) {
        InputStream inputStream;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(file));
        }
        catch (Exception exception) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (Exception exception2) {
                throw new RuntimeException(exception);
            }
        }
        this.setInput(inputStream);
    }

    public void setInput(InputStream inputStream) {
        AbstFile abstFile = new AbstFile();
        abstFile.inputStreamToBuffer(inputStream, "");
        this.setInput(abstFile);
    }

    public void setInput(AbstFile abstFile) {
        this.mInputAbstFile = abstFile;
    }

    public void setOutput(File file) {
        this.setOutput(file, false);
    }

    public void setOutput(File file, boolean bl) {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            if (bl) {
                outputStream = new GZIPOutputStream(outputStream);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.setOutput(outputStream);
    }

    public void setOutput(OutputStream outputStream) {
        this.mOutputStream = outputStream;
        outputStream = new AbstFile();
        outputStream.openNewFileToBuffer("");
        this.setOutput((AbstFile)outputStream);
    }

    public void setOutput(AbstFile abstFile) {
        this.mOutputAbstFile = abstFile;
    }
}

