/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.format.auto3ds.element;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;
import jp.kitec.format.auto3ds.Chunk;
import jp.kitec.format.auto3ds.Reader;
import jp.kitec.format.auto3ds.Writer;

public class TriVertexl
extends Chunk {
    List<Point3f> mVertexs = new ArrayList<Point3f>();

    public TriVertexl() {
        super((short)16656);
    }

    public void addVertex(Point3f point3f) {
        this.mVertexs.add(point3f);
    }

    public List<Point3f> getVertexs() {
        return this.mVertexs;
    }

    @Override
    protected int selfSize() {
        return SIZE_SHORT + this.mVertexs.size() * SIZE_FLOAT * 3;
    }

    @Override
    protected void writeBody(Writer writer) {
        writer.writeShort(this.mVertexs.size());
        for (Point3f point3f : this.mVertexs) {
            writer.writeFloat(point3f.x);
            writer.writeFloat(point3f.y);
            writer.writeFloat(point3f.z);
        }
    }

    @Override
    protected void readChildren(Reader reader, int n) {
        int n2 = reader.getPosition();
        int n3 = n2 + n;
        int n4 = reader.readUShort();
        this.mVertexs.clear();
        for (int i = 0; i < n4; ++i) {
            Point3f point3f = new Point3f();
            point3f.x = reader.readFloat();
            point3f.y = reader.readFloat();
            point3f.z = reader.readFloat();
            this.mVertexs.add(point3f);
        }
    }

    @Override
    public void dump(PrintStream printStream, int n) {
        super.dump(printStream, n);
        StringBuilder stringBuilder = new StringBuilder(n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('>');
        }
        printStream.print(stringBuilder);
        printStream.println(this.mVertexs.size());
        printStream.print(stringBuilder);
        for (Point3f point3f : this.mVertexs) {
            printStream.print(point3f);
        }
        printStream.println();
    }
}

