/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.format.auto3ds.element;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.TexCoord2f;
import jp.kitec.format.auto3ds.Chunk;
import jp.kitec.format.auto3ds.Reader;
import jp.kitec.format.auto3ds.Writer;

public class TriMappingCoords
extends Chunk {
    List<TexCoord2f> mPoints = new ArrayList<TexCoord2f>();

    public TriMappingCoords() {
        super((short)16704);
    }

    public void addVertex(TexCoord2f texCoord2f) {
        this.mPoints.add(texCoord2f);
    }

    public List<TexCoord2f> getVertex() {
        return this.mPoints;
    }

    @Override
    protected int selfSize() {
        return SIZE_SHORT + this.mPoints.size() * SIZE_FLOAT * 2;
    }

    @Override
    protected void writeBody(Writer writer) {
        if (this.mPoints.size() != (0xFFFF & (short)this.mPoints.size())) {
            throw new IllegalStateException("too large chunk");
        }
        writer.writeShort((short)this.mPoints.size());
        for (TexCoord2f texCoord2f : this.mPoints) {
            writer.writeFloat(texCoord2f.x);
            writer.writeFloat(texCoord2f.y);
        }
    }

    @Override
    protected void readChildren(Reader reader, int n) {
        int n2 = reader.getPosition();
        int n3 = n2 + n;
        int n4 = reader.readUShort();
        this.mPoints.clear();
        for (int i = 0; i < n4; ++i) {
            TexCoord2f texCoord2f = new TexCoord2f();
            texCoord2f.x = reader.readFloat();
            texCoord2f.y = reader.readFloat();
            this.mPoints.add(texCoord2f);
        }
    }

    @Override
    public void dump(PrintStream printStream, int n) {
        super.dump(printStream, n);
        StringBuilder stringBuilder = new StringBuilder(n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('>');
        }
        printStream.print(stringBuilder);
        printStream.println(this.mPoints.size());
        printStream.print(stringBuilder);
        for (TexCoord2f texCoord2f : this.mPoints) {
            printStream.print(texCoord2f);
        }
        printStream.println();
    }
}

