/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.format.auto3ds.element;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import jp.kitec.format.auto3ds.Chunk;
import jp.kitec.format.auto3ds.Reader;
import jp.kitec.format.auto3ds.Writer;

public class TriFacel1
extends Chunk {
    private List<Face> mFaces = new ArrayList<Face>();

    public TriFacel1() {
        super((short)16672);
    }

    public void addFace(int n, int n2, int n3, int n4) {
        this.mFaces.add(new Face(n, n2, n3, n4));
    }

    public List<Face> getFaces() {
        return this.mFaces;
    }

    @Override
    protected int selfSize() {
        return SIZE_SHORT + SIZE_SHORT * 4 * this.mFaces.size();
    }

    @Override
    protected void writeBody(Writer writer) {
        writer.writeShort(this.mFaces.size());
        for (Face face : this.mFaces) {
            writer.writeShort(face.va);
            writer.writeShort(face.vb);
            writer.writeShort(face.vc);
            writer.writeShort(face.flag);
        }
    }

    @Override
    protected void readChildren(Reader reader, int n) {
        int n2 = reader.getPosition();
        int n3 = n2 + n;
        int n4 = reader.readUShort();
        this.mFaces.clear();
        for (int i = 0; i < n4; ++i) {
            int n5 = reader.readUShort();
            int n6 = reader.readUShort();
            int n7 = reader.readUShort();
            int n8 = reader.readUShort();
            this.mFaces.add(new Face(n5, n6, n7, n8));
        }
        while (reader.getPosition() < n3) {
            Chunk chunk = reader.createChunkTri();
            if (chunk == null) {
                throw new RuntimeException("chunk " + Integer.toHexString(0xFFFF & reader.readShort()));
            }
            chunk.read(reader);
            this.addChunk(chunk);
        }
    }

    @Override
    public void dump(PrintStream printStream, int n) {
        super.dump(printStream, n);
        StringBuilder stringBuilder = new StringBuilder(n);
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("*-");
        }
        printStream.print(stringBuilder);
        printStream.println(this.mFaces.size());
        printStream.print(stringBuilder);
        for (Face face : this.mFaces) {
            printStream.print(face);
        }
        printStream.println();
    }

    public static class Face {
        public int va;
        public int vb;
        public int vc;
        public int flag;

        public Face(int n, int n2, int n3, int n4) {
            this.va = n;
            this.vb = n2;
            this.vc = n3;
            this.flag = n4;
        }

        public String toString() {
            return "[" + this.va + ", " + this.vb + ", " + this.vc + " " + this.flag + "]";
        }
    }
}

