/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.format.auto3ds.element;

import java.io.PrintStream;
import jp.kitec.format.auto3ds.Chunk;
import jp.kitec.format.auto3ds.Reader;
import jp.kitec.format.auto3ds.Writer;

public class ColTru
extends Chunk {
    int mR;
    int mG;
    int mB;

    public ColTru() {
        super((short)17);
    }

    public ColTru(int n, int n2, int n3) {
        super((short)17);
        this.mR = n;
        this.mG = n2;
        this.mB = n3;
    }

    public int getRGB() {
        return this.mR << 16 | this.mG << 8 | this.mB;
    }

    @Override
    protected int selfSize() {
        return 3;
    }

    @Override
    protected void writeBody(Writer writer) {
        writer.writeByte(this.mR);
        writer.writeByte(this.mG);
        writer.writeByte(this.mB);
    }

    @Override
    protected void readChildren(Reader reader, int n) {
        if (n != 3) {
            throw new IllegalArgumentException("len:" + n);
        }
        this.mR = reader.readByte() & 0xFF;
        this.mG = reader.readByte() & 0xFF;
        this.mB = reader.readByte() & 0xFF;
    }

    @Override
    public void dump(PrintStream printStream, int n) {
        super.dump(printStream, n);
        this.printIndent(printStream, n);
        printStream.println("[" + Integer.toHexString(this.mR) + ", " + Integer.toHexString(this.mG) + ", " + Integer.toHexString(this.mB) + "]");
    }
}

