/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.format.auto3ds.element;

import java.io.PrintStream;
import jp.kitec.format.auto3ds.Chunk;
import jp.kitec.format.auto3ds.Reader;
import jp.kitec.format.auto3ds.Writer;

public class ChunkFloat
extends Chunk {
    float mValue;

    public ChunkFloat(short s) {
        super(s);
    }

    public ChunkFloat(short s, float f) {
        this(s);
        this.mValue = f;
    }

    public void setValue(float f) {
        this.mValue = f;
    }

    @Override
    protected int selfSize() {
        return SIZE_FLOAT;
    }

    @Override
    protected void writeBody(Writer writer) {
        writer.writeFloat(this.mValue);
    }

    @Override
    protected void readChildren(Reader reader, int n) {
        if (n != SIZE_FLOAT) {
            throw new IllegalArgumentException("len:" + n);
        }
        this.mValue = reader.readFloat();
    }

    @Override
    public void dump(PrintStream printStream, int n) {
        super.dump(printStream, n);
        this.printIndent(printStream, n);
        printStream.println("[" + this.mValue + "]");
    }
}

