/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.format.auto3ds;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.kitec.format.auto3ds.IChunkID;
import jp.kitec.format.auto3ds.Reader;
import jp.kitec.format.auto3ds.Writer;

public class Chunk
implements IChunkID {
    private short mID;
    private ArrayList<Chunk> mChildren;
    private byte[] mOpt;
    public static int SIZE_SHORT = 2;
    public static int SIZE_INT = 4;
    public static int SIZE_FLOAT = 4;

    public Chunk(short s) {
        this.mID = s;
        this.mChildren = new ArrayList();
    }

    public short getID() {
        return this.mID;
    }

    public void addChunk(Chunk chunk) {
        this.mChildren.add(chunk);
    }

    public List<Chunk> getChildren() {
        return Collections.unmodifiableList(this.mChildren);
    }

    public List<Chunk> getChildren(short s) {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (Chunk chunk : this.mChildren) {
            if (chunk.mID != s) continue;
            arrayList.add(chunk);
        }
        return arrayList;
    }

    public Chunk getChild(short s) {
        for (Chunk chunk : this.mChildren) {
            if (chunk.mID != s) continue;
            return chunk;
        }
        return null;
    }

    public final int size() {
        int n = SIZE_SHORT + SIZE_INT;
        n += this.selfSize();
        for (Chunk chunk : this.mChildren) {
            n += chunk.size();
        }
        return n;
    }

    protected int selfSize() {
        return this.mOpt == null ? 0 : this.mOpt.length;
    }

    public int read(Reader reader) {
        int n = reader.readInt();
        int n2 = reader.getPosition();
        this.readChildren(reader, n - 6);
        if (reader.getPosition() != n2 + n - 6) {
            this.dump(System.err, 0);
            new IllegalStateException(this.toString() + "/ptr " + reader.getPosition() + " " + (n2 + n - 6)).printStackTrace();
        }
        return n;
    }

    protected void readChildren(Reader reader, int n) {
        this.mOpt = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.mOpt[i] = reader.readByte();
        }
    }

    public final void write(Writer writer) {
        int n = this.size();
        int n2 = writer.getPosition();
        this.writeHeader(writer);
        this.writeBody(writer);
        this.writeChildren(writer);
        if (writer.getPosition() != n2 + n) {
            new IllegalStateException(writer.getPosition() + "/" + (n2 + n)).printStackTrace();
        }
    }

    protected void writeHeader(Writer writer) {
        writer.writeShort(this.mID);
        writer.writeInt(this.size());
    }

    protected void writeBody(Writer writer) {
        if (this.mOpt != null) {
            for (byte by : this.mOpt) {
                writer.writeByte(by);
            }
        }
    }

    protected void writeChildren(Writer writer) {
        for (Chunk chunk : this.mChildren) {
            try {
                chunk.write(writer);
            }
            catch (RuntimeException runtimeException) {
                System.err.println(runtimeException + " while writing " + chunk);
                throw runtimeException;
            }
        }
    }

    protected void printIndent(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print(' ');
        }
    }

    public void dump(PrintStream printStream, int n) {
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                printStream.print(' ');
            }
            printStream.print('+');
        }
        printStream.println(this.toString());
        for (Chunk chunk : this.mChildren) {
            chunk.dump(printStream, n + 1);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(0x" + Integer.toHexString(this.mID & 0xFFFF) + ')';
    }
}

