/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.util.HashMap;
import java.util.Map;
import option.gad.core.util.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoManager {
    protected static ClassInfoManager mInstance = new ClassInfoManager();
    protected boolean mCacheable = true;
    protected Map<String, ClassInfo> mStringKeyMap = new HashMap<String, ClassInfo>();

    protected ClassInfoManager() {
    }

    public static ClassInfoManager getInstance() {
        return mInstance;
    }

    public ClassInfo getClassInfo(Class<?> clazz) {
        ClassInfo classInfo = null;
        if (this.mCacheable) {
            classInfo = this.mStringKeyMap.get(clazz.getName());
        }
        if (classInfo == null) {
            classInfo = new ClassInfo(clazz);
            this.mStringKeyMap.put(classInfo.getType().getName(), classInfo);
        }
        return classInfo;
    }

    public ClassInfo getClassInfo(String string) {
        ClassInfo classInfo = null;
        if (this.mCacheable) {
            classInfo = this.mStringKeyMap.get(string);
        }
        if (classInfo == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (clazz != null) {
                classInfo = new ClassInfo(clazz);
                this.mStringKeyMap.put(string, classInfo);
            }
        }
        return classInfo;
    }

    public void setCacheable(boolean bl) {
        this.mCacheable = bl;
    }
}

